%------------------------------------------------------------------------------
% File     : COM207^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Parallel extension to grammars and languages 111
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : parallel__111.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  339 ( 124 unt;  66 typ;   0 def)
%            Number of atoms       :  641 ( 243 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4582 (  51   ~;   3   |;  22   &;4179   @)
%                                         (   0 <=>; 327  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   9 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  490 ( 490   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   66 (  63 usr;   5 con; 0-9 aty)
%            Number of variables   : 1386 (  59   ^;1220   !;  14   ?;1386   :)
%                                         (  93  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:39:10.825
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Sum__Type_Osum,type,
    sum_sum: $tType > $tType > $tType ).

thf(ty_t_DTree_Odtree,type,
    dtree: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_DTree_OT,type,
    t: $tType ).

thf(ty_t_DTree_ON,type,
    n: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (59)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder__top,type,
    order_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_BNF__Cardinal__Order__Relation_OrelChain,type,
    bNF_Ca1785829860lChain: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( A > B ) > $o ) ).

thf(sy_c_BNF__Def_Ocsquare,type,
    bNF_csquare: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( set @ A ) > ( B > C ) > ( D > C ) > ( A > B ) > ( A > D ) > $o ) ).

thf(sy_c_BNF__Def_OfstOp,type,
    bNF_fstOp: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > $o ) > ( B > C > $o ) > ( product_prod @ A @ C ) > ( product_prod @ A @ B ) ) ).

thf(sy_c_BNF__Def_Opick__middlep,type,
    bNF_pick_middlep: 
      !>[B: $tType,A: $tType,C: $tType] : ( ( B > A > $o ) > ( A > C > $o ) > B > C > A ) ).

thf(sy_c_BNF__Def_OsndOp,type,
    bNF_sndOp: 
      !>[C: $tType,A: $tType,B: $tType] : ( ( C > A > $o ) > ( A > B > $o ) > ( product_prod @ C @ B ) > ( product_prod @ A @ B ) ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Oimage2,type,
    bNF_Greatest_image2: 
      !>[C: $tType,A: $tType,B: $tType] : ( ( set @ C ) > ( C > A ) > ( C > B ) > ( set @ ( product_prod @ A @ B ) ) ) ).

thf(sy_c_DTree_ONode,type,
    node: n > ( set @ ( sum_sum @ t @ dtree ) ) > dtree ).

thf(sy_c_DTree_Ocont,type,
    cont: dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_DTree_Ocorec,type,
    corec: 
      !>[A: $tType] : ( ( A > n ) > ( A > ( set @ ( sum_sum @ t @ ( sum_sum @ dtree @ A ) ) ) ) > A > dtree ) ).

thf(sy_c_DTree_Odtree_Oroot,type,
    root: dtree > n ).

thf(sy_c_DTree_Ounfold,type,
    unfold: 
      !>[A: $tType] : ( ( A > n ) > ( A > ( set @ ( sum_sum @ t @ A ) ) ) > A > dtree ) ).

thf(sy_c_Fun_Oinj__on,type,
    inj_on: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > $o ) ).

thf(sy_c_Fun_Oswap,type,
    swap: 
      !>[A: $tType,B: $tType] : ( A > A > ( A > B ) > A > B ) ).

thf(sy_c_Fun_Othe__inv__into,type,
    the_inv_into: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( A > B ) > B > A ) ).

thf(sy_c_Fun__Def_Oin__rel,type,
    fun_in_rel: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > A > B > $o ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Parallel__Mirabelle__hykpkoupgu_ONplus,type,
    parall1518086719_Nplus: n > n > n ).

thf(sy_c_Parallel__Mirabelle__hykpkoupgu_Opar,type,
    parall1899940088le_par: ( product_prod @ dtree @ dtree ) > dtree ).

thf(sy_c_Parallel__Mirabelle__hykpkoupgu_Opar__c,type,
    parall1914194347_par_c: ( product_prod @ dtree @ dtree ) > ( set @ ( sum_sum @ t @ ( product_prod @ dtree @ dtree ) ) ) ).

thf(sy_c_Parallel__Mirabelle__hykpkoupgu_Opar__r,type,
    parall1914194362_par_r: ( product_prod @ dtree @ dtree ) > n ).

thf(sy_c_Parallel__Mirabelle__hykpkoupgu_Opar__r__rel,type,
    parall556292031_r_rel: ( product_prod @ dtree @ dtree ) > ( product_prod @ dtree @ dtree ) > $o ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Oapfst,type,
    product_apfst: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( A > C ) > ( product_prod @ A @ B ) > ( product_prod @ C @ B ) ) ).

thf(sy_c_Product__Type_Oapsnd,type,
    product_apsnd: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( product_prod @ A @ B ) > ( product_prod @ A @ C ) ) ).

thf(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( ( product_prod @ A @ B ) > C ) > A > B > C ) ).

thf(sy_c_Product__Type_Ointernal__case__prod,type,
    produc2004651681e_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Omap__prod,type,
    product_map_prod: 
      !>[A: $tType,C: $tType,B: $tType,D: $tType] : ( ( A > C ) > ( B > D ) > ( product_prod @ A @ B ) > ( product_prod @ C @ D ) ) ).

thf(sy_c_Product__Type_Oold_Obool_Orec__bool,type,
    product_rec_bool: 
      !>[T: $tType] : ( T > T > $o > T ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Product__Type_Oprod_Ocase__prod,type,
    product_case_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oprod_Ofst,type,
    product_fst: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > A ) ).

thf(sy_c_Product__Type_Oprod_Osnd,type,
    product_snd: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > B ) ).

thf(sy_c_Product__Type_Oprod_Oswap,type,
    product_swap: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > ( product_prod @ B @ A ) ) ).

thf(sy_c_Product__Type_Oscomp,type,
    product_scomp: 
      !>[A: $tType,B: $tType,C: $tType,D: $tType] : ( ( A > ( product_prod @ B @ C ) ) > ( B > C > D ) > A > D ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Relation_OPowp,type,
    powp: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_Relation_Oinv__image,type,
    inv_image: 
      !>[B: $tType,A: $tType] : ( ( set @ ( product_prod @ B @ B ) ) > ( A > B ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Relation_Orelcompp,type,
    relcompp: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > $o ) > ( B > C > $o ) > A > C > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > ( set @ B ) ) ).

thf(sy_c_Sum__Type_OInl,type,
    sum_Inl: 
      !>[A: $tType,B: $tType] : ( A > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( ( A > A > $o ) > A > $o ) ).

thf(sy_c_Wellfounded_Olex__prod,type,
    lex_prod: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ B @ B ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_Wellfounded_Owf,type,
    wf: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Wfrec_Osame__fst,type,
    same_fst: 
      !>[A: $tType,B: $tType] : ( ( A > $o ) > ( A > ( set @ ( product_prod @ B @ B ) ) ) > ( set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_tr1,type,
    tr1: dtree ).

thf(sy_v_tr2,type,
    tr2: dtree ).

thf(sy_v_tr3,type,
    tr3: dtree ).

%----Relevant facts (256)
thf(fact_0_par__com,axiom,
    ! [Tr1: dtree,Tr2: dtree] :
      ( ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ Tr1 @ Tr2 ) )
      = ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ Tr2 @ Tr1 ) ) ) ).

% par_com
thf(fact_1_par__r_Ocases,axiom,
    ! [X: product_prod @ dtree @ dtree] :
      ~ ! [Tr12: dtree,Tr22: dtree] :
          ( X
         != ( product_Pair @ dtree @ dtree @ Tr12 @ Tr22 ) ) ).

% par_r.cases
thf(fact_2_par__r_Oinduct,axiom,
    ! [P: ( product_prod @ dtree @ dtree ) > $o,A0: product_prod @ dtree @ dtree] :
      ( ! [Tr12: dtree,Tr22: dtree] : ( P @ ( product_Pair @ dtree @ dtree @ Tr12 @ Tr22 ) )
     => ( P @ A0 ) ) ).

% par_r.induct
thf(fact_3_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B,Y1: A,Y2: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X2 )
        = ( product_Pair @ A @ B @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X2 = Y2 ) ) ) ).

% prod.inject
thf(fact_4_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
      = ( ( A2 = A3 )
        & ( B2 = B3 ) ) ) ).

% old.prod.inject
thf(fact_5_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod @ A @ B] :
    ? [X3: A,Y: B] :
      ( P2
      = ( product_Pair @ A @ B @ X3 @ Y ) ) ).

% surj_pair
thf(fact_6_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P2: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ P2 ) ) ).

% prod_cases
thf(fact_7_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
     => ~ ( ( A2 = A3 )
         => ( B2 != B3 ) ) ) ).

% Pair_inject
thf(fact_8_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y3: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A4: A,B4: B,C2: C] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C2 ) ) ) ).

% prod_cases3
thf(fact_9_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) )] :
      ~ ! [A4: A,B4: B,C2: C,D2: D] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D ) @ B4 @ ( product_Pair @ C @ D @ C2 @ D2 ) ) ) ) ).

% prod_cases4
thf(fact_10_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) )] :
      ~ ! [A4: A,B4: B,C2: C,D2: D,E2: E] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ E ) @ C2 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_11_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) )] :
      ~ ! [A4: A,B4: B,C2: C,D2: D,E2: E,F2: F] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) @ C2 @ ( product_Pair @ D @ ( product_prod @ E @ F ) @ D2 @ ( product_Pair @ E @ F @ E2 @ F2 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_12_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E: $tType,F: $tType,G: $tType,Y3: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) )] :
      ~ ! [A4: A,B4: B,C2: C,D2: D,E2: E,F2: F,G2: G] :
          ( Y3
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) @ C2 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F @ G ) @ E2 @ ( product_Pair @ F @ G @ F2 @ G2 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_13_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A4: A,B4: B,C2: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C2 ) ) )
     => ( P @ X ) ) ).

% prod_induct3
thf(fact_14_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) )] :
      ( ! [A4: A,B4: B,C2: C,D2: D] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D ) @ B4 @ ( product_Pair @ C @ D @ C2 @ D2 ) ) ) )
     => ( P @ X ) ) ).

% prod_induct4
thf(fact_15_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_16_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y3: product_prod @ A @ B] :
      ~ ! [A4: A,B4: B] :
          ( Y3
         != ( product_Pair @ A @ B @ A4 @ B4 ) ) ).

% old.prod.exhaust
thf(fact_17_prod__induct7,axiom,
    ! [G: $tType,F: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) )] :
      ( ! [A4: A,B4: B,C2: C,D2: D,E2: E,F2: F,G2: G] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) ) @ C2 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F @ G ) @ E2 @ ( product_Pair @ F @ G @ F2 @ G2 ) ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct7
thf(fact_18_prod__induct6,axiom,
    ! [F: $tType,E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) )] :
      ( ! [A4: A,B4: B,C2: C,D2: D,E2: E,F2: F] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ ( product_prod @ E @ F ) ) @ C2 @ ( product_Pair @ D @ ( product_prod @ E @ F ) @ D2 @ ( product_Pair @ E @ F @ E2 @ F2 ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct6
thf(fact_19_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) )] :
      ( ! [A4: A,B4: B,C2: C,D2: D,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D @ E ) @ C2 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct5
thf(fact_20_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B2: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
      = ( F1 @ A2 @ B2 ) ) ).

% old.prod.rec
thf(fact_21_internal__case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,C3: B > C > A,A2: B,B2: C] :
      ( ( produc2004651681e_prod @ B @ C @ A @ C3 @ ( product_Pair @ B @ C @ A2 @ B2 ) )
      = ( C3 @ A2 @ B2 ) ) ).

% internal_case_prod_conv
thf(fact_22_ssubst__Pair__rhs,axiom,
    ! [B: $tType,A: $tType,R: A,S: B,R2: set @ ( product_prod @ A @ B ),S2: B] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R @ S ) @ R2 )
     => ( ( S2 = S )
       => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R @ S2 ) @ R2 ) ) ) ).

% ssubst_Pair_rhs
thf(fact_23_curry__conv,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( product_curry @ B @ C @ A )
      = ( ^ [F3: ( product_prod @ B @ C ) > A,A5: B,B5: C] : ( F3 @ ( product_Pair @ B @ C @ A5 @ B5 ) ) ) ) ).

% curry_conv
thf(fact_24_curryI,axiom,
    ! [A: $tType,B: $tType,F4: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( F4 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
     => ( product_curry @ A @ B @ $o @ F4 @ A2 @ B2 ) ) ).

% curryI
thf(fact_25_swap__simp,axiom,
    ! [A: $tType,B: $tType,X: B,Y3: A] :
      ( ( product_swap @ B @ A @ ( product_Pair @ B @ A @ X @ Y3 ) )
      = ( product_Pair @ A @ B @ Y3 @ X ) ) ).

% swap_simp
thf(fact_26_apsnd__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,F4: C > B,X: A,Y3: C] :
      ( ( product_apsnd @ C @ B @ A @ F4 @ ( product_Pair @ A @ C @ X @ Y3 ) )
      = ( product_Pair @ A @ B @ X @ ( F4 @ Y3 ) ) ) ).

% apsnd_conv
thf(fact_27_old_Obool_Osimps_I6_J,axiom,
    ! [T: $tType,F1: T,F22: T] :
      ( ( product_rec_bool @ T @ F1 @ F22 @ $false )
      = F22 ) ).

% old.bool.simps(6)
thf(fact_28_old_Obool_Osimps_I5_J,axiom,
    ! [T: $tType,F1: T,F22: T] :
      ( ( product_rec_bool @ T @ F1 @ F22 @ $true )
      = F1 ) ).

% old.bool.simps(5)
thf(fact_29_apfst__conv,axiom,
    ! [C: $tType,A: $tType,B: $tType,F4: C > A,X: C,Y3: B] :
      ( ( product_apfst @ C @ A @ B @ F4 @ ( product_Pair @ C @ B @ X @ Y3 ) )
      = ( product_Pair @ A @ B @ ( F4 @ X ) @ Y3 ) ) ).

% apfst_conv
thf(fact_30_swap__swap,axiom,
    ! [B: $tType,A: $tType,P2: product_prod @ A @ B] :
      ( ( product_swap @ B @ A @ ( product_swap @ A @ B @ P2 ) )
      = P2 ) ).

% swap_swap
thf(fact_31_apsnd__apfst__commute,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,F4: C > B,G3: D > A,P2: product_prod @ D @ C] :
      ( ( product_apsnd @ C @ B @ A @ F4 @ ( product_apfst @ D @ A @ C @ G3 @ P2 ) )
      = ( product_apfst @ D @ A @ B @ G3 @ ( product_apsnd @ C @ B @ D @ F4 @ P2 ) ) ) ).

% apsnd_apfst_commute
thf(fact_32_curryD,axiom,
    ! [A: $tType,B: $tType,F4: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( product_curry @ A @ B @ $o @ F4 @ A2 @ B2 )
     => ( F4 @ ( product_Pair @ A @ B @ A2 @ B2 ) ) ) ).

% curryD
thf(fact_33_curryE,axiom,
    ! [A: $tType,B: $tType,F4: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( product_curry @ A @ B @ $o @ F4 @ A2 @ B2 )
     => ( F4 @ ( product_Pair @ A @ B @ A2 @ B2 ) ) ) ).

% curryE
thf(fact_34_pair__in__swap__image,axiom,
    ! [A: $tType,B: $tType,Y3: A,X: B,A6: set @ ( product_prod @ B @ A )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Y3 @ X ) @ ( image @ ( product_prod @ B @ A ) @ ( product_prod @ A @ B ) @ ( product_swap @ B @ A ) @ A6 ) )
      = ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X @ Y3 ) @ A6 ) ) ).

% pair_in_swap_image
thf(fact_35_internal__case__prod__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( produc2004651681e_prod @ A @ B @ C )
      = ( product_case_prod @ A @ B @ C ) ) ).

% internal_case_prod_def
thf(fact_36_case__prod__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F4: ( product_prod @ A @ B ) > C] :
      ( ( product_case_prod @ A @ B @ C @ ( product_curry @ A @ B @ C @ F4 ) )
      = F4 ) ).

% case_prod_curry
thf(fact_37_curry__case__prod,axiom,
    ! [C: $tType,B: $tType,A: $tType,F4: A > B > C] :
      ( ( product_curry @ A @ B @ C @ ( product_case_prod @ A @ B @ C @ F4 ) )
      = F4 ) ).

% curry_case_prod
thf(fact_38_Pair__scomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,X: C,F4: C > A > B] :
      ( ( product_scomp @ A @ C @ A @ B @ ( product_Pair @ C @ A @ X ) @ F4 )
      = ( F4 @ X ) ) ).

% Pair_scomp
thf(fact_39_root__par,axiom,
    ! [Tr1: dtree,Tr2: dtree] :
      ( ( root @ ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ Tr1 @ Tr2 ) ) )
      = ( parall1518086719_Nplus @ ( root @ Tr1 ) @ ( root @ Tr2 ) ) ) ).

% root_par
thf(fact_40_same__fstI,axiom,
    ! [B: $tType,A: $tType,P: A > $o,X: A,Y4: B,Y3: B,R2: A > ( set @ ( product_prod @ B @ B ) )] :
      ( ( P @ X )
     => ( ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ Y4 @ Y3 ) @ ( R2 @ X ) )
       => ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y4 ) @ ( product_Pair @ A @ B @ X @ Y3 ) ) @ ( same_fst @ A @ B @ P @ R2 ) ) ) ) ).

% same_fstI
thf(fact_41_in__lex__prod,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B,R: set @ ( product_prod @ A @ A ),S: set @ ( product_prod @ B @ B )] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ ( product_Pair @ A @ B @ A3 @ B3 ) ) @ ( lex_prod @ A @ B @ R @ S ) )
      = ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A3 ) @ R )
        | ( ( A2 = A3 )
          & ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ B2 @ B3 ) @ S ) ) ) ) ).

% in_lex_prod
thf(fact_42_apfst__apsnd,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,F4: C > A,G3: D > B,X: product_prod @ C @ D] :
      ( ( product_apfst @ C @ A @ B @ F4 @ ( product_apsnd @ D @ B @ C @ G3 @ X ) )
      = ( product_Pair @ A @ B @ ( F4 @ ( product_fst @ C @ D @ X ) ) @ ( G3 @ ( product_snd @ C @ D @ X ) ) ) ) ).

% apfst_apsnd
thf(fact_43_scomp__apply,axiom,
    ! [A: $tType,D: $tType,C: $tType,B: $tType] :
      ( ( product_scomp @ B @ C @ D @ A )
      = ( ^ [F3: B > ( product_prod @ C @ D ),G4: C > D > A,X4: B] : ( product_case_prod @ C @ D @ A @ G4 @ ( F3 @ X4 ) ) ) ) ).

% scomp_apply
thf(fact_44_apfst__eq__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,F4: C > A,X: product_prod @ C @ B,G3: C > A] :
      ( ( ( product_apfst @ C @ A @ B @ F4 @ X )
        = ( product_apfst @ C @ A @ B @ G3 @ X ) )
      = ( ( F4 @ ( product_fst @ C @ B @ X ) )
        = ( G3 @ ( product_fst @ C @ B @ X ) ) ) ) ).

% apfst_eq_conv
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A6: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A6 ) )
      = A6 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F4: A > B,G3: A > B] :
      ( ! [X3: A] :
          ( ( F4 @ X3 )
          = ( G3 @ X3 ) )
     => ( F4 = G3 ) ) ).

% ext
thf(fact_49_fst__apfst,axiom,
    ! [A: $tType,B: $tType,C: $tType,F4: C > A,X: product_prod @ C @ B] :
      ( ( product_fst @ A @ B @ ( product_apfst @ C @ A @ B @ F4 @ X ) )
      = ( F4 @ ( product_fst @ C @ B @ X ) ) ) ).

% fst_apfst
thf(fact_50_snd__apfst,axiom,
    ! [B: $tType,A: $tType,C: $tType,F4: C > B,X: product_prod @ C @ A] :
      ( ( product_snd @ B @ A @ ( product_apfst @ C @ B @ A @ F4 @ X ) )
      = ( product_snd @ C @ A @ X ) ) ).

% snd_apfst
thf(fact_51_fst__apsnd,axiom,
    ! [B: $tType,C: $tType,A: $tType,F4: C > B,X: product_prod @ A @ C] :
      ( ( product_fst @ A @ B @ ( product_apsnd @ C @ B @ A @ F4 @ X ) )
      = ( product_fst @ A @ C @ X ) ) ).

% fst_apsnd
thf(fact_52_apsnd__eq__conv,axiom,
    ! [B: $tType,C: $tType,A: $tType,F4: C > B,X: product_prod @ A @ C,G3: C > B] :
      ( ( ( product_apsnd @ C @ B @ A @ F4 @ X )
        = ( product_apsnd @ C @ B @ A @ G3 @ X ) )
      = ( ( F4 @ ( product_snd @ A @ C @ X ) )
        = ( G3 @ ( product_snd @ A @ C @ X ) ) ) ) ).

% apsnd_eq_conv
thf(fact_53_snd__apsnd,axiom,
    ! [A: $tType,C: $tType,B: $tType,F4: C > A,X: product_prod @ B @ C] :
      ( ( product_snd @ B @ A @ ( product_apsnd @ C @ A @ B @ F4 @ X ) )
      = ( F4 @ ( product_snd @ B @ C @ X ) ) ) ).

% snd_apsnd
thf(fact_54_prod_Ocollapse,axiom,
    ! [B: $tType,A: $tType,Prod: product_prod @ A @ B] :
      ( ( product_Pair @ A @ B @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) )
      = Prod ) ).

% prod.collapse
thf(fact_55_snd__swap,axiom,
    ! [B: $tType,A: $tType,X: product_prod @ A @ B] :
      ( ( product_snd @ B @ A @ ( product_swap @ A @ B @ X ) )
      = ( product_fst @ A @ B @ X ) ) ).

% snd_swap
thf(fact_56_fst__swap,axiom,
    ! [A: $tType,B: $tType,X: product_prod @ B @ A] :
      ( ( product_fst @ A @ B @ ( product_swap @ B @ A @ X ) )
      = ( product_snd @ B @ A @ X ) ) ).

% fst_swap
thf(fact_57_apsnd__apfst,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,F4: C > B,G3: D > A,X: product_prod @ D @ C] :
      ( ( product_apsnd @ C @ B @ A @ F4 @ ( product_apfst @ D @ A @ C @ G3 @ X ) )
      = ( product_Pair @ A @ B @ ( G3 @ ( product_fst @ D @ C @ X ) ) @ ( F4 @ ( product_snd @ D @ C @ X ) ) ) ) ).

% apsnd_apfst
thf(fact_58_Nplus__comm,axiom,
    ( parall1518086719_Nplus
    = ( ^ [A5: n,B5: n] : ( parall1518086719_Nplus @ B5 @ A5 ) ) ) ).

% Nplus_comm
thf(fact_59_Nplus__assoc,axiom,
    ! [A2: n,B2: n,C3: n] :
      ( ( parall1518086719_Nplus @ ( parall1518086719_Nplus @ A2 @ B2 ) @ C3 )
      = ( parall1518086719_Nplus @ A2 @ ( parall1518086719_Nplus @ B2 @ C3 ) ) ) ).

% Nplus_assoc
thf(fact_60_surjective__pairing,axiom,
    ! [B: $tType,A: $tType,T2: product_prod @ A @ B] :
      ( T2
      = ( product_Pair @ A @ B @ ( product_fst @ A @ B @ T2 ) @ ( product_snd @ A @ B @ T2 ) ) ) ).

% surjective_pairing
thf(fact_61_prod_Osplit__sel__asm,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: C > $o,F4: A > B > C,Prod: product_prod @ A @ B] :
      ( ( P @ ( product_case_prod @ A @ B @ C @ F4 @ Prod ) )
      = ( ~ ( ( Prod
              = ( product_Pair @ A @ B @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) ) )
            & ~ ( P @ ( F4 @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) ) ) ) ) ) ).

% prod.split_sel_asm
thf(fact_62_Product__Type_OCollect__case__prodD,axiom,
    ! [B: $tType,A: $tType,X: product_prod @ A @ B,A6: A > B > $o] :
      ( ( member @ ( product_prod @ A @ B ) @ X @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ A6 ) ) )
     => ( A6 @ ( product_fst @ A @ B @ X ) @ ( product_snd @ A @ B @ X ) ) ) ).

% Product_Type.Collect_case_prodD
thf(fact_63_prod_Oexhaust__sel,axiom,
    ! [B: $tType,A: $tType,Prod: product_prod @ A @ B] :
      ( Prod
      = ( product_Pair @ A @ B @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) ) ) ).

% prod.exhaust_sel
thf(fact_64_prod_Ocase__eq__if,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( product_case_prod @ A @ B @ C )
      = ( ^ [F3: A > B > C,Prod2: product_prod @ A @ B] : ( F3 @ ( product_fst @ A @ B @ Prod2 ) @ ( product_snd @ A @ B @ Prod2 ) ) ) ) ).

% prod.case_eq_if
thf(fact_65_prod_Osplit__sel,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: C > $o,F4: A > B > C,Prod: product_prod @ A @ B] :
      ( ( P @ ( product_case_prod @ A @ B @ C @ F4 @ Prod ) )
      = ( ( Prod
          = ( product_Pair @ A @ B @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) ) )
       => ( P @ ( F4 @ ( product_fst @ A @ B @ Prod ) @ ( product_snd @ A @ B @ Prod ) ) ) ) ) ).

% prod.split_sel
thf(fact_66_case__prod__beta,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( product_case_prod @ B @ C @ A )
      = ( ^ [F3: B > C > A,P3: product_prod @ B @ C] : ( F3 @ ( product_fst @ B @ C @ P3 ) @ ( product_snd @ B @ C @ P3 ) ) ) ) ).

% case_prod_beta
thf(fact_67_prod__eq__iff,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [Y5: product_prod @ A @ B,Z: product_prod @ A @ B] : ( Y5 = Z ) )
      = ( ^ [S3: product_prod @ A @ B,T3: product_prod @ A @ B] :
            ( ( ( product_fst @ A @ B @ S3 )
              = ( product_fst @ A @ B @ T3 ) )
            & ( ( product_snd @ A @ B @ S3 )
              = ( product_snd @ A @ B @ T3 ) ) ) ) ) ).

% prod_eq_iff
thf(fact_68_prod_Oexpand,axiom,
    ! [B: $tType,A: $tType,Prod: product_prod @ A @ B,Prod3: product_prod @ A @ B] :
      ( ( ( ( product_fst @ A @ B @ Prod )
          = ( product_fst @ A @ B @ Prod3 ) )
        & ( ( product_snd @ A @ B @ Prod )
          = ( product_snd @ A @ B @ Prod3 ) ) )
     => ( Prod = Prod3 ) ) ).

% prod.expand
thf(fact_69_scomp__def,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType] :
      ( ( product_scomp @ A @ B @ C @ D )
      = ( ^ [F3: A > ( product_prod @ B @ C ),G4: B > C > D,X4: A] : ( product_case_prod @ B @ C @ D @ G4 @ ( F3 @ X4 ) ) ) ) ).

% scomp_def
thf(fact_70_prod__eqI,axiom,
    ! [B: $tType,A: $tType,P2: product_prod @ A @ B,Q2: product_prod @ A @ B] :
      ( ( ( product_fst @ A @ B @ P2 )
        = ( product_fst @ A @ B @ Q2 ) )
     => ( ( ( product_snd @ A @ B @ P2 )
          = ( product_snd @ A @ B @ Q2 ) )
       => ( P2 = Q2 ) ) ) ).

% prod_eqI
thf(fact_71_prod_Oswap__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( product_swap @ A @ B )
      = ( ^ [P3: product_prod @ A @ B] : ( product_Pair @ B @ A @ ( product_snd @ A @ B @ P3 ) @ ( product_fst @ A @ B @ P3 ) ) ) ) ).

% prod.swap_def
thf(fact_72_snd__conv,axiom,
    ! [Aa: $tType,A: $tType,X1: Aa,X2: A] :
      ( ( product_snd @ Aa @ A @ ( product_Pair @ Aa @ A @ X1 @ X2 ) )
      = X2 ) ).

% snd_conv
thf(fact_73_snd__eqD,axiom,
    ! [B: $tType,A: $tType,X: B,Y3: A,A2: A] :
      ( ( ( product_snd @ B @ A @ ( product_Pair @ B @ A @ X @ Y3 ) )
        = A2 )
     => ( Y3 = A2 ) ) ).

% snd_eqD
thf(fact_74_fst__conv,axiom,
    ! [B: $tType,A: $tType,X1: A,X2: B] :
      ( ( product_fst @ A @ B @ ( product_Pair @ A @ B @ X1 @ X2 ) )
      = X1 ) ).

% fst_conv
thf(fact_75_fst__eqD,axiom,
    ! [B: $tType,A: $tType,X: A,Y3: B,A2: A] :
      ( ( ( product_fst @ A @ B @ ( product_Pair @ A @ B @ X @ Y3 ) )
        = A2 )
     => ( X = A2 ) ) ).

% fst_eqD
thf(fact_76_mem__case__prodE,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z2: A,C3: B > C > ( set @ A ),P2: product_prod @ B @ C] :
      ( ( member @ A @ Z2 @ ( product_case_prod @ B @ C @ ( set @ A ) @ C3 @ P2 ) )
     => ~ ! [X3: B,Y: C] :
            ( ( P2
              = ( product_Pair @ B @ C @ X3 @ Y ) )
           => ~ ( member @ A @ Z2 @ ( C3 @ X3 @ Y ) ) ) ) ).

% mem_case_prodE
thf(fact_77_old_Oprod_Ocase,axiom,
    ! [A: $tType,C: $tType,B: $tType,F4: A > B > C,X1: A,X2: B] :
      ( ( product_case_prod @ A @ B @ C @ F4 @ ( product_Pair @ A @ B @ X1 @ X2 ) )
      = ( F4 @ X1 @ X2 ) ) ).

% old.prod.case
thf(fact_78_scomp__Pair,axiom,
    ! [C: $tType,B: $tType,A: $tType,X: A > ( product_prod @ B @ C )] :
      ( ( product_scomp @ A @ B @ C @ ( product_prod @ B @ C ) @ X @ ( product_Pair @ B @ C ) )
      = X ) ).

% scomp_Pair
thf(fact_79_BNF__Greatest__Fixpoint_Osubst__Pair,axiom,
    ! [B: $tType,A: $tType,P: A > B > $o,X: A,Y3: B,A2: product_prod @ A @ B] :
      ( ( P @ X @ Y3 )
     => ( ( A2
          = ( product_Pair @ A @ B @ X @ Y3 ) )
       => ( P @ ( product_fst @ A @ B @ A2 ) @ ( product_snd @ A @ B @ A2 ) ) ) ) ).

% BNF_Greatest_Fixpoint.subst_Pair
thf(fact_80_conjI__realizer,axiom,
    ! [A: $tType,B: $tType,P: A > $o,P2: A,Q: B > $o,Q2: B] :
      ( ( P @ P2 )
     => ( ( Q @ Q2 )
       => ( ( P @ ( product_fst @ A @ B @ ( product_Pair @ A @ B @ P2 @ Q2 ) ) )
          & ( Q @ ( product_snd @ A @ B @ ( product_Pair @ A @ B @ P2 @ Q2 ) ) ) ) ) ) ).

% conjI_realizer
thf(fact_81_exI__realizer,axiom,
    ! [B: $tType,A: $tType,P: A > B > $o,Y3: A,X: B] :
      ( ( P @ Y3 @ X )
     => ( P @ ( product_snd @ B @ A @ ( product_Pair @ B @ A @ X @ Y3 ) ) @ ( product_fst @ B @ A @ ( product_Pair @ B @ A @ X @ Y3 ) ) ) ) ).

% exI_realizer
thf(fact_82_par__r_Osimps,axiom,
    ! [Tr1: dtree,Tr2: dtree] :
      ( ( parall1914194362_par_r @ ( product_Pair @ dtree @ dtree @ Tr1 @ Tr2 ) )
      = ( parall1518086719_Nplus @ ( root @ Tr1 ) @ ( root @ Tr2 ) ) ) ).

% par_r.simps
thf(fact_83_par__r_Oelims,axiom,
    ! [X: product_prod @ dtree @ dtree,Y3: n] :
      ( ( ( parall1914194362_par_r @ X )
        = Y3 )
     => ~ ! [Tr12: dtree,Tr22: dtree] :
            ( ( X
              = ( product_Pair @ dtree @ dtree @ Tr12 @ Tr22 ) )
           => ( Y3
             != ( parall1518086719_Nplus @ ( root @ Tr12 ) @ ( root @ Tr22 ) ) ) ) ) ).

% par_r.elims
thf(fact_84_image__eqI,axiom,
    ! [A: $tType,B: $tType,B2: A,F4: B > A,X: B,A6: set @ B] :
      ( ( B2
        = ( F4 @ X ) )
     => ( ( member @ B @ X @ A6 )
       => ( member @ A @ B2 @ ( image @ B @ A @ F4 @ A6 ) ) ) ) ).

% image_eqI
thf(fact_85_exE__realizer_H,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,P2: product_prod @ B @ A] :
      ( ( P @ ( product_snd @ B @ A @ P2 ) @ ( product_fst @ B @ A @ P2 ) )
     => ~ ! [X3: B,Y: A] :
            ~ ( P @ Y @ X3 ) ) ).

% exE_realizer'
thf(fact_86_sndI,axiom,
    ! [A: $tType,B: $tType,X: product_prod @ A @ B,Y3: A,Z2: B] :
      ( ( X
        = ( product_Pair @ A @ B @ Y3 @ Z2 ) )
     => ( ( product_snd @ A @ B @ X )
        = Z2 ) ) ).

% sndI
thf(fact_87_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,X: A,A6: set @ A,B2: B,F4: A > B] :
      ( ( member @ A @ X @ A6 )
     => ( ( B2
          = ( F4 @ X ) )
       => ( member @ B @ B2 @ ( image @ A @ B @ F4 @ A6 ) ) ) ) ).

% rev_image_eqI
thf(fact_88_ball__imageD,axiom,
    ! [A: $tType,B: $tType,F4: B > A,A6: set @ B,P: A > $o] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ ( image @ B @ A @ F4 @ A6 ) )
         => ( P @ X3 ) )
     => ! [X5: B] :
          ( ( member @ B @ X5 @ A6 )
         => ( P @ ( F4 @ X5 ) ) ) ) ).

% ball_imageD
thf(fact_89_image__cong,axiom,
    ! [B: $tType,A: $tType,M: set @ A,N: set @ A,F4: A > B,G3: A > B] :
      ( ( M = N )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ N )
           => ( ( F4 @ X3 )
              = ( G3 @ X3 ) ) )
       => ( ( image @ A @ B @ F4 @ M )
          = ( image @ A @ B @ G3 @ N ) ) ) ) ).

% image_cong
thf(fact_90_bex__imageD,axiom,
    ! [A: $tType,B: $tType,F4: B > A,A6: set @ B,P: A > $o] :
      ( ? [X5: A] :
          ( ( member @ A @ X5 @ ( image @ B @ A @ F4 @ A6 ) )
          & ( P @ X5 ) )
     => ? [X3: B] :
          ( ( member @ B @ X3 @ A6 )
          & ( P @ ( F4 @ X3 ) ) ) ) ).

% bex_imageD
thf(fact_91_image__iff,axiom,
    ! [A: $tType,B: $tType,Z2: A,F4: B > A,A6: set @ B] :
      ( ( member @ A @ Z2 @ ( image @ B @ A @ F4 @ A6 ) )
      = ( ? [X4: B] :
            ( ( member @ B @ X4 @ A6 )
            & ( Z2
              = ( F4 @ X4 ) ) ) ) ) ).

% image_iff
thf(fact_92_imageI,axiom,
    ! [B: $tType,A: $tType,X: A,A6: set @ A,F4: A > B] :
      ( ( member @ A @ X @ A6 )
     => ( member @ B @ ( F4 @ X ) @ ( image @ A @ B @ F4 @ A6 ) ) ) ).

% imageI
thf(fact_93_fstI,axiom,
    ! [B: $tType,A: $tType,X: product_prod @ A @ B,Y3: A,Z2: B] :
      ( ( X
        = ( product_Pair @ A @ B @ Y3 @ Z2 ) )
     => ( ( product_fst @ A @ B @ X )
        = Y3 ) ) ).

% fstI
thf(fact_94_eq__snd__iff,axiom,
    ! [A: $tType,B: $tType,B2: A,P2: product_prod @ B @ A] :
      ( ( B2
        = ( product_snd @ B @ A @ P2 ) )
      = ( ? [A5: B] :
            ( P2
            = ( product_Pair @ B @ A @ A5 @ B2 ) ) ) ) ).

% eq_snd_iff
thf(fact_95_eq__fst__iff,axiom,
    ! [A: $tType,B: $tType,A2: A,P2: product_prod @ A @ B] :
      ( ( A2
        = ( product_fst @ A @ B @ P2 ) )
      = ( ? [B5: B] :
            ( P2
            = ( product_Pair @ A @ B @ A2 @ B5 ) ) ) ) ).

% eq_fst_iff
thf(fact_96_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,Q2: product_prod @ A @ B,F4: A > B > C,G3: A > B > C,P2: product_prod @ A @ B] :
      ( ! [X3: A,Y: B] :
          ( ( ( product_Pair @ A @ B @ X3 @ Y )
            = Q2 )
         => ( ( F4 @ X3 @ Y )
            = ( G3 @ X3 @ Y ) ) )
     => ( ( P2 = Q2 )
       => ( ( product_case_prod @ A @ B @ C @ F4 @ P2 )
          = ( product_case_prod @ A @ B @ C @ G3 @ Q2 ) ) ) ) ).

% split_cong
thf(fact_97_par__r_Opelims,axiom,
    ! [X: product_prod @ dtree @ dtree,Y3: n] :
      ( ( ( parall1914194362_par_r @ X )
        = Y3 )
     => ( ( accp @ ( product_prod @ dtree @ dtree ) @ parall556292031_r_rel @ X )
       => ~ ! [Tr12: dtree,Tr22: dtree] :
              ( ( X
                = ( product_Pair @ dtree @ dtree @ Tr12 @ Tr22 ) )
             => ( ( Y3
                  = ( parall1518086719_Nplus @ ( root @ Tr12 ) @ ( root @ Tr22 ) ) )
               => ~ ( accp @ ( product_prod @ dtree @ dtree ) @ parall556292031_r_rel @ ( product_Pair @ dtree @ dtree @ Tr12 @ Tr22 ) ) ) ) ) ) ).

% par_r.pelims
thf(fact_98_Collect__split__mono__strong,axiom,
    ! [B: $tType,A: $tType,X6: set @ A,A6: set @ ( product_prod @ A @ B ),Y6: set @ B,P: A > B > $o,Q: A > B > $o] :
      ( ( X6
        = ( image @ ( product_prod @ A @ B ) @ A @ ( product_fst @ A @ B ) @ A6 ) )
     => ( ( Y6
          = ( image @ ( product_prod @ A @ B ) @ B @ ( product_snd @ A @ B ) @ A6 ) )
       => ( ! [X3: A] :
              ( ( member @ A @ X3 @ X6 )
             => ! [Xa: B] :
                  ( ( member @ B @ Xa @ Y6 )
                 => ( ( P @ X3 @ Xa )
                   => ( Q @ X3 @ Xa ) ) ) )
         => ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ A6 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ P ) ) )
           => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ A6 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ Q ) ) ) ) ) ) ) ).

% Collect_split_mono_strong
thf(fact_99_fstOp__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( bNF_fstOp @ A @ B @ C )
      = ( ^ [P4: A > B > $o,Q3: B > C > $o,Ac: product_prod @ A @ C] : ( product_Pair @ A @ B @ ( product_fst @ A @ C @ Ac ) @ ( bNF_pick_middlep @ A @ B @ C @ P4 @ Q3 @ ( product_fst @ A @ C @ Ac ) @ ( product_snd @ A @ C @ Ac ) ) ) ) ) ).

% fstOp_def
thf(fact_100_subset__antisym,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( ord_less_eq @ ( set @ A ) @ B6 @ A6 )
       => ( A6 = B6 ) ) ) ).

% subset_antisym
thf(fact_101_subsetI,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A6 )
         => ( member @ A @ X3 @ B6 ) )
     => ( ord_less_eq @ ( set @ A ) @ A6 @ B6 ) ) ).

% subsetI
thf(fact_102_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X4: A] :
            ( ( P @ X4 )
           => ( Q @ X4 ) ) ) ) ).

% Collect_mono_iff
thf(fact_103_contra__subsetD,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,C3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ~ ( member @ A @ C3 @ B6 )
       => ~ ( member @ A @ C3 @ A6 ) ) ) ).

% contra_subsetD
thf(fact_104_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y5: set @ A,Z: set @ A] : ( Y5 = Z ) )
      = ( ^ [A7: set @ A,B7: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A7 @ B7 )
            & ( ord_less_eq @ ( set @ A ) @ B7 @ A7 ) ) ) ) ).

% set_eq_subset
thf(fact_105_subset__trans,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( ord_less_eq @ ( set @ A ) @ B6 @ C4 )
       => ( ord_less_eq @ ( set @ A ) @ A6 @ C4 ) ) ) ).

% subset_trans
thf(fact_106_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_107_subset__refl,axiom,
    ! [A: $tType,A6: set @ A] : ( ord_less_eq @ ( set @ A ) @ A6 @ A6 ) ).

% subset_refl
thf(fact_108_rev__subsetD,axiom,
    ! [A: $tType,C3: A,A6: set @ A,B6: set @ A] :
      ( ( member @ A @ C3 @ A6 )
     => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
       => ( member @ A @ C3 @ B6 ) ) ) ).

% rev_subsetD
thf(fact_109_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A7: set @ A,B7: set @ A] :
          ! [T3: A] :
            ( ( member @ A @ T3 @ A7 )
           => ( member @ A @ T3 @ B7 ) ) ) ) ).

% subset_iff
thf(fact_110_set__rev__mp,axiom,
    ! [A: $tType,X: A,A6: set @ A,B6: set @ A] :
      ( ( member @ A @ X @ A6 )
     => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
       => ( member @ A @ X @ B6 ) ) ) ).

% set_rev_mp
thf(fact_111_equalityD2,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( A6 = B6 )
     => ( ord_less_eq @ ( set @ A ) @ B6 @ A6 ) ) ).

% equalityD2
thf(fact_112_equalityD1,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( A6 = B6 )
     => ( ord_less_eq @ ( set @ A ) @ A6 @ B6 ) ) ).

% equalityD1
thf(fact_113_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A7: set @ A,B7: set @ A] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A7 )
           => ( member @ A @ X4 @ B7 ) ) ) ) ).

% subset_eq
thf(fact_114_equalityE,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( A6 = B6 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B6 @ A6 ) ) ) ).

% equalityE
thf(fact_115_subsetCE,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,C3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( member @ A @ C3 @ A6 )
       => ( member @ A @ C3 @ B6 ) ) ) ).

% subsetCE
thf(fact_116_subsetD,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,C3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( member @ A @ C3 @ A6 )
       => ( member @ A @ C3 @ B6 ) ) ) ).

% subsetD
thf(fact_117_in__mono,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( member @ A @ X @ A6 )
       => ( member @ A @ X @ B6 ) ) ) ).

% in_mono
thf(fact_118_set__mp,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ( member @ A @ X @ A6 )
       => ( member @ A @ X @ B6 ) ) ) ).

% set_mp
thf(fact_119_accp__induct__rule,axiom,
    ! [A: $tType,R: A > A > $o,A2: A,P: A > $o] :
      ( ( accp @ A @ R @ A2 )
     => ( ! [X3: A] :
            ( ( accp @ A @ R @ X3 )
           => ( ! [Y7: A] :
                  ( ( R @ Y7 @ X3 )
                 => ( P @ Y7 ) )
             => ( P @ X3 ) ) )
       => ( P @ A2 ) ) ) ).

% accp_induct_rule
thf(fact_120_not__accp__down,axiom,
    ! [A: $tType,R2: A > A > $o,X: A] :
      ( ~ ( accp @ A @ R2 @ X )
     => ~ ! [Z3: A] :
            ( ( R2 @ Z3 @ X )
           => ( accp @ A @ R2 @ Z3 ) ) ) ).

% not_accp_down
thf(fact_121_accp__downward,axiom,
    ! [A: $tType,R: A > A > $o,B2: A,A2: A] :
      ( ( accp @ A @ R @ B2 )
     => ( ( R @ A2 @ B2 )
       => ( accp @ A @ R @ A2 ) ) ) ).

% accp_downward
thf(fact_122_accp_Oinducts,axiom,
    ! [A: $tType,R: A > A > $o,X: A,P: A > $o] :
      ( ( accp @ A @ R @ X )
     => ( ! [X3: A] :
            ( ! [Y7: A] :
                ( ( R @ Y7 @ X3 )
               => ( accp @ A @ R @ Y7 ) )
           => ( ! [Y7: A] :
                  ( ( R @ Y7 @ X3 )
                 => ( P @ Y7 ) )
             => ( P @ X3 ) ) )
       => ( P @ X ) ) ) ).

% accp.inducts
thf(fact_123_accp__induct,axiom,
    ! [A: $tType,R: A > A > $o,A2: A,P: A > $o] :
      ( ( accp @ A @ R @ A2 )
     => ( ! [X3: A] :
            ( ( accp @ A @ R @ X3 )
           => ( ! [Y7: A] :
                  ( ( R @ Y7 @ X3 )
                 => ( P @ Y7 ) )
             => ( P @ X3 ) ) )
       => ( P @ A2 ) ) ) ).

% accp_induct
thf(fact_124_accp_Ointros,axiom,
    ! [A: $tType,R: A > A > $o,X: A] :
      ( ! [Y: A] :
          ( ( R @ Y @ X )
         => ( accp @ A @ R @ Y ) )
     => ( accp @ A @ R @ X ) ) ).

% accp.intros
thf(fact_125_accp_Osimps,axiom,
    ! [A: $tType] :
      ( ( accp @ A )
      = ( ^ [R3: A > A > $o,A5: A] :
          ? [X4: A] :
            ( ( A5 = X4 )
            & ! [Y8: A] :
                ( ( R3 @ Y8 @ X4 )
               => ( accp @ A @ R3 @ Y8 ) ) ) ) ) ).

% accp.simps
thf(fact_126_accp_Ocases,axiom,
    ! [A: $tType,R: A > A > $o,A2: A] :
      ( ( accp @ A @ R @ A2 )
     => ! [Y7: A] :
          ( ( R @ Y7 @ A2 )
         => ( accp @ A @ R @ Y7 ) ) ) ).

% accp.cases
thf(fact_127_subset__image__iff,axiom,
    ! [A: $tType,B: $tType,B6: set @ A,F4: B > A,A6: set @ B] :
      ( ( ord_less_eq @ ( set @ A ) @ B6 @ ( image @ B @ A @ F4 @ A6 ) )
      = ( ? [AA: set @ B] :
            ( ( ord_less_eq @ ( set @ B ) @ AA @ A6 )
            & ( B6
              = ( image @ B @ A @ F4 @ AA ) ) ) ) ) ).

% subset_image_iff
thf(fact_128_image__subset__iff,axiom,
    ! [A: $tType,B: $tType,F4: B > A,A6: set @ B,B6: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( image @ B @ A @ F4 @ A6 ) @ B6 )
      = ( ! [X4: B] :
            ( ( member @ B @ X4 @ A6 )
           => ( member @ A @ ( F4 @ X4 ) @ B6 ) ) ) ) ).

% image_subset_iff
thf(fact_129_subset__imageE,axiom,
    ! [A: $tType,B: $tType,B6: set @ A,F4: B > A,A6: set @ B] :
      ( ( ord_less_eq @ ( set @ A ) @ B6 @ ( image @ B @ A @ F4 @ A6 ) )
     => ~ ! [C5: set @ B] :
            ( ( ord_less_eq @ ( set @ B ) @ C5 @ A6 )
           => ( B6
             != ( image @ B @ A @ F4 @ C5 ) ) ) ) ).

% subset_imageE
thf(fact_130_image__subsetI,axiom,
    ! [A: $tType,B: $tType,A6: set @ A,F4: A > B,B6: set @ B] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A6 )
         => ( member @ B @ ( F4 @ X3 ) @ B6 ) )
     => ( ord_less_eq @ ( set @ B ) @ ( image @ A @ B @ F4 @ A6 ) @ B6 ) ) ).

% image_subsetI
thf(fact_131_image__mono,axiom,
    ! [B: $tType,A: $tType,A6: set @ A,B6: set @ A,F4: A > B] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ord_less_eq @ ( set @ B ) @ ( image @ A @ B @ F4 @ A6 ) @ ( image @ A @ B @ F4 @ B6 ) ) ) ).

% image_mono
thf(fact_132_sndOp__def,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( ( bNF_sndOp @ C @ A @ B )
      = ( ^ [P4: C > A > $o,Q3: A > B > $o,Ac: product_prod @ C @ B] : ( product_Pair @ A @ B @ ( bNF_pick_middlep @ C @ A @ B @ P4 @ Q3 @ ( product_fst @ C @ B @ Ac ) @ ( product_snd @ C @ B @ Ac ) ) @ ( product_snd @ C @ B @ Ac ) ) ) ) ).

% sndOp_def
thf(fact_133_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_134_subrelI,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B ),S: set @ ( product_prod @ A @ B )] :
      ( ! [X3: A,Y: B] :
          ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y ) @ R )
         => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y ) @ S ) )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ R @ S ) ) ).

% subrelI
thf(fact_135_relChain__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( bNF_Ca1785829860lChain @ A @ B )
        = ( ^ [R3: set @ ( product_prod @ A @ A ),As: A > B] :
            ! [I: A,J: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ I @ J ) @ R3 )
             => ( ord_less_eq @ B @ ( As @ I ) @ ( As @ J ) ) ) ) ) ) ).

% relChain_def
thf(fact_136_Collect__case__prod__in__rel__leE,axiom,
    ! [B: $tType,A: $tType,X6: set @ ( product_prod @ A @ B ),Y6: set @ ( product_prod @ A @ B )] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ X6 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ ( fun_in_rel @ A @ B @ Y6 ) ) ) )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ X6 @ Y6 ) ) ).

% Collect_case_prod_in_rel_leE
thf(fact_137_accp__subset,axiom,
    ! [A: $tType,R1: A > A > $o,R22: A > A > $o] :
      ( ( ord_less_eq @ ( A > A > $o ) @ R1 @ R22 )
     => ( ord_less_eq @ ( A > $o ) @ ( accp @ A @ R22 ) @ ( accp @ A @ R1 ) ) ) ).

% accp_subset
thf(fact_138_accp__subset__induct,axiom,
    ! [A: $tType,D3: A > $o,R2: A > A > $o,X: A,P: A > $o] :
      ( ( ord_less_eq @ ( A > $o ) @ D3 @ ( accp @ A @ R2 ) )
     => ( ! [X3: A,Z3: A] :
            ( ( D3 @ X3 )
           => ( ( R2 @ Z3 @ X3 )
             => ( D3 @ Z3 ) ) )
       => ( ( D3 @ X )
         => ( ! [X3: A] :
                ( ( D3 @ X3 )
               => ( ! [Z4: A] :
                      ( ( R2 @ Z4 @ X3 )
                     => ( P @ Z4 ) )
                 => ( P @ X3 ) ) )
           => ( P @ X ) ) ) ) ) ).

% accp_subset_induct
thf(fact_139_in__rel__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( fun_in_rel @ A @ B )
      = ( ^ [R4: set @ ( product_prod @ A @ B ),X4: A,Y8: B] : ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X4 @ Y8 ) @ R4 ) ) ) ).

% in_rel_def
thf(fact_140_in__rel__Collect__case__prod__eq,axiom,
    ! [B: $tType,A: $tType,X6: A > B > $o] :
      ( ( fun_in_rel @ A @ B @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ X6 ) ) )
      = X6 ) ).

% in_rel_Collect_case_prod_eq
thf(fact_141_Collect__case__prod__mono,axiom,
    ! [B: $tType,A: $tType,A6: A > B > $o,B6: A > B > $o] :
      ( ( ord_less_eq @ ( A > B > $o ) @ A6 @ B6 )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ A6 ) ) @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ B6 ) ) ) ) ).

% Collect_case_prod_mono
thf(fact_142_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_143_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C3: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C3 @ B2 )
           => ( ord_less_eq @ A @ C3 @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_144_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
             => ( P @ A4 @ B4 ) )
         => ( ! [A4: A,B4: A] :
                ( ( P @ B4 @ A4 )
               => ( P @ A4 @ B4 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_145_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_146_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A,Z2: A] :
          ( ( ord_less_eq @ A @ X @ Y3 )
         => ( ( ord_less_eq @ A @ Y3 @ Z2 )
           => ( ord_less_eq @ A @ X @ Z2 ) ) ) ) ).

% order_trans
thf(fact_147_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_148_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C3: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C3 )
           => ( ord_less_eq @ A @ A2 @ C3 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_149_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C3: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C3 )
           => ( ord_less_eq @ A @ A2 @ C3 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_150_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y3: A,X: A] :
          ( ( ord_less_eq @ A @ Y3 @ X )
         => ( ( ord_less_eq @ A @ X @ Y3 )
            = ( X = Y3 ) ) ) ) ).

% antisym_conv
thf(fact_151_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A,Z2: A] :
          ( ( ( ord_less_eq @ A @ X @ Y3 )
           => ~ ( ord_less_eq @ A @ Y3 @ Z2 ) )
         => ( ( ( ord_less_eq @ A @ Y3 @ X )
             => ~ ( ord_less_eq @ A @ X @ Z2 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z2 )
               => ~ ( ord_less_eq @ A @ Z2 @ Y3 ) )
             => ( ( ( ord_less_eq @ A @ Z2 @ Y3 )
                 => ~ ( ord_less_eq @ A @ Y3 @ X ) )
               => ( ( ( ord_less_eq @ A @ Y3 @ Z2 )
                   => ~ ( ord_less_eq @ A @ Z2 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z2 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y3 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_152_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C3: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C3 )
           => ( ord_less_eq @ A @ A2 @ C3 ) ) ) ) ).

% order.trans
thf(fact_153_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y3 )
         => ( ord_less_eq @ A @ Y3 @ X ) ) ) ).

% le_cases
thf(fact_154_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ( X = Y3 )
         => ( ord_less_eq @ A @ X @ Y3 ) ) ) ).

% eq_refl
thf(fact_155_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ( ord_less_eq @ A @ X @ Y3 )
          | ( ord_less_eq @ A @ Y3 @ X ) ) ) ).

% linear
thf(fact_156_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ( ord_less_eq @ A @ X @ Y3 )
         => ( ( ord_less_eq @ A @ Y3 @ X )
           => ( X = Y3 ) ) ) ) ).

% antisym
thf(fact_157_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y5: A,Z: A] : ( Y5 = Z ) )
        = ( ^ [X4: A,Y8: A] :
              ( ( ord_less_eq @ A @ X4 @ Y8 )
              & ( ord_less_eq @ A @ Y8 @ X4 ) ) ) ) ) ).

% eq_iff
thf(fact_158_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F4: A > B,C3: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F4 @ B2 )
              = C3 )
           => ( ! [X3: A,Y: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y )
                 => ( ord_less_eq @ B @ ( F4 @ X3 ) @ ( F4 @ Y ) ) )
             => ( ord_less_eq @ B @ ( F4 @ A2 ) @ C3 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_159_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F4: B > A,B2: B,C3: B] :
          ( ( A2
            = ( F4 @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C3 )
           => ( ! [X3: B,Y: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y )
                 => ( ord_less_eq @ A @ ( F4 @ X3 ) @ ( F4 @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F4 @ C3 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_160_order__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C @ ( type2 @ C ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F4: A > C,C3: C] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C @ ( F4 @ B2 ) @ C3 )
           => ( ! [X3: A,Y: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y )
                 => ( ord_less_eq @ C @ ( F4 @ X3 ) @ ( F4 @ Y ) ) )
             => ( ord_less_eq @ C @ ( F4 @ A2 ) @ C3 ) ) ) ) ) ).

% order_subst2
thf(fact_161_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F4: B > A,B2: B,C3: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F4 @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C3 )
           => ( ! [X3: B,Y: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y )
                 => ( ord_less_eq @ A @ ( F4 @ X3 ) @ ( F4 @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F4 @ C3 ) ) ) ) ) ) ).

% order_subst1
thf(fact_162_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F3: A > B,G4: A > B] :
            ! [X4: A] : ( ord_less_eq @ B @ ( F3 @ X4 ) @ ( G4 @ X4 ) ) ) ) ) ).

% le_fun_def
thf(fact_163_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F4: A > B,G3: A > B] :
          ( ! [X3: A] : ( ord_less_eq @ B @ ( F4 @ X3 ) @ ( G3 @ X3 ) )
         => ( ord_less_eq @ ( A > B ) @ F4 @ G3 ) ) ) ).

% le_funI
thf(fact_164_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F4: A > B,G3: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F4 @ G3 )
         => ( ord_less_eq @ B @ ( F4 @ X ) @ ( G3 @ X ) ) ) ) ).

% le_funE
thf(fact_165_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F4: A > B,G3: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F4 @ G3 )
         => ( ord_less_eq @ B @ ( F4 @ X ) @ ( G3 @ X ) ) ) ) ).

% le_funD
thf(fact_166_Collect__case__prod__in__rel__leI,axiom,
    ! [B: $tType,A: $tType,X6: set @ ( product_prod @ A @ B ),Y6: set @ ( product_prod @ A @ B )] :
      ( ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ X6 @ Y6 )
     => ( ord_less_eq @ ( set @ ( product_prod @ A @ B ) ) @ X6 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ ( fun_in_rel @ A @ B @ Y6 ) ) ) ) ) ).

% Collect_case_prod_in_rel_leI
thf(fact_167_csquare__fstOp__sndOp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F4: ( A > B > $o ) > ( product_prod @ A @ B ) > $o,P: A > C > $o,Q: C > B > $o] : ( bNF_csquare @ ( product_prod @ A @ B ) @ ( product_prod @ A @ C ) @ C @ ( product_prod @ C @ B ) @ ( collect @ ( product_prod @ A @ B ) @ ( F4 @ ( relcompp @ A @ C @ B @ P @ Q ) ) ) @ ( product_snd @ A @ C ) @ ( product_fst @ C @ B ) @ ( bNF_fstOp @ A @ C @ B @ P @ Q ) @ ( bNF_sndOp @ A @ C @ B @ P @ Q ) ) ).

% csquare_fstOp_sndOp
thf(fact_168_image2__eqI,axiom,
    ! [A: $tType,C: $tType,B: $tType,B2: A,F4: B > A,X: B,C3: C,G3: B > C,A6: set @ B] :
      ( ( B2
        = ( F4 @ X ) )
     => ( ( C3
          = ( G3 @ X ) )
       => ( ( member @ B @ X @ A6 )
         => ( member @ ( product_prod @ A @ C ) @ ( product_Pair @ A @ C @ B2 @ C3 ) @ ( bNF_Greatest_image2 @ B @ A @ C @ A6 @ F4 @ G3 ) ) ) ) ) ).

% image2_eqI
thf(fact_169_surj__swap,axiom,
    ! [B: $tType,A: $tType] :
      ( ( image @ ( product_prod @ B @ A ) @ ( product_prod @ A @ B ) @ ( product_swap @ B @ A ) @ ( top_top @ ( set @ ( product_prod @ B @ A ) ) ) )
      = ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) ) ).

% surj_swap
thf(fact_170_par__def,axiom,
    ( parall1899940088le_par
    = ( unfold @ ( product_prod @ dtree @ dtree ) @ parall1914194362_par_r @ parall1914194347_par_c ) ) ).

% par_def
thf(fact_171_UNIV__I,axiom,
    ! [A: $tType,X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_I
thf(fact_172_predicate2I,axiom,
    ! [B: $tType,A: $tType,P: A > B > $o,Q: A > B > $o] :
      ( ! [X3: A,Y: B] :
          ( ( P @ X3 @ Y )
         => ( Q @ X3 @ Y ) )
     => ( ord_less_eq @ ( A > B > $o ) @ P @ Q ) ) ).

% predicate2I
thf(fact_173_predicate1I,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( A > $o ) @ P @ Q ) ) ).

% predicate1I
thf(fact_174_range__fst,axiom,
    ! [B: $tType,A: $tType] :
      ( ( image @ ( product_prod @ A @ B ) @ A @ ( product_fst @ A @ B ) @ ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% range_fst
thf(fact_175_range__snd,axiom,
    ! [B: $tType,A: $tType] :
      ( ( image @ ( product_prod @ B @ A ) @ A @ ( product_snd @ B @ A ) @ ( top_top @ ( set @ ( product_prod @ B @ A ) ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% range_snd
thf(fact_176_refl__ge__eq,axiom,
    ! [A: $tType,R2: A > A > $o] :
      ( ! [X3: A] : ( R2 @ X3 @ X3 )
     => ( ord_less_eq @ ( A > A > $o )
        @ ^ [Y5: A,Z: A] : ( Y5 = Z )
        @ R2 ) ) ).

% refl_ge_eq
thf(fact_177_ge__eq__refl,axiom,
    ! [A: $tType,R2: A > A > $o,X: A] :
      ( ( ord_less_eq @ ( A > A > $o )
        @ ^ [Y5: A,Z: A] : ( Y5 = Z )
        @ R2 )
     => ( R2 @ X @ X ) ) ).

% ge_eq_refl
thf(fact_178_leq__OOI,axiom,
    ! [A: $tType,R2: A > A > $o] :
      ( ( R2
        = ( ^ [Y5: A,Z: A] : ( Y5 = Z ) ) )
     => ( ord_less_eq @ ( A > A > $o ) @ R2 @ ( relcompp @ A @ A @ A @ R2 @ R2 ) ) ) ).

% leq_OOI
thf(fact_179_predicate1D,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o,X: A] :
      ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
     => ( ( P @ X )
       => ( Q @ X ) ) ) ).

% predicate1D
thf(fact_180_predicate2D,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,Q: A > B > $o,X: A,Y3: B] :
      ( ( ord_less_eq @ ( A > B > $o ) @ P @ Q )
     => ( ( P @ X @ Y3 )
       => ( Q @ X @ Y3 ) ) ) ).

% predicate2D
thf(fact_181_relcompp__mono,axiom,
    ! [A: $tType,C: $tType,B: $tType,R5: A > B > $o,R: A > B > $o,S2: B > C > $o,S: B > C > $o] :
      ( ( ord_less_eq @ ( A > B > $o ) @ R5 @ R )
     => ( ( ord_less_eq @ ( B > C > $o ) @ S2 @ S )
       => ( ord_less_eq @ ( A > C > $o ) @ ( relcompp @ A @ B @ C @ R5 @ S2 ) @ ( relcompp @ A @ B @ C @ R @ S ) ) ) ) ).

% relcompp_mono
thf(fact_182_rev__predicate1D,axiom,
    ! [A: $tType,P: A > $o,X: A,Q: A > $o] :
      ( ( P @ X )
     => ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
       => ( Q @ X ) ) ) ).

% rev_predicate1D
thf(fact_183_rev__predicate2D,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,X: A,Y3: B,Q: A > B > $o] :
      ( ( P @ X @ Y3 )
     => ( ( ord_less_eq @ ( A > B > $o ) @ P @ Q )
       => ( Q @ X @ Y3 ) ) ) ).

% rev_predicate2D
thf(fact_184_top__greatest,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ ( top_top @ A ) ) ) ).

% top_greatest
thf(fact_185_top_Oextremum__unique,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( top_top @ A ) @ A2 )
          = ( A2
            = ( top_top @ A ) ) ) ) ).

% top.extremum_unique
thf(fact_186_top_Oextremum__uniqueI,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( top_top @ A ) @ A2 )
         => ( A2
            = ( top_top @ A ) ) ) ) ).

% top.extremum_uniqueI
thf(fact_187_rangeI,axiom,
    ! [A: $tType,B: $tType,F4: B > A,X: B] : ( member @ A @ ( F4 @ X ) @ ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) ) ) ).

% rangeI
thf(fact_188_range__eqI,axiom,
    ! [A: $tType,B: $tType,B2: A,F4: B > A,X: B] :
      ( ( B2
        = ( F4 @ X ) )
     => ( member @ A @ B2 @ ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) ) ) ) ).

% range_eqI
thf(fact_189_subset__UNIV,axiom,
    ! [A: $tType,A6: set @ A] : ( ord_less_eq @ ( set @ A ) @ A6 @ ( top_top @ ( set @ A ) ) ) ).

% subset_UNIV
thf(fact_190_pick__middlep,axiom,
    ! [B: $tType,A: $tType,C: $tType,P: A > B > $o,Q: B > C > $o,A2: A,C3: C] :
      ( ( relcompp @ A @ B @ C @ P @ Q @ A2 @ C3 )
     => ( ( P @ A2 @ ( bNF_pick_middlep @ A @ B @ C @ P @ Q @ A2 @ C3 ) )
        & ( Q @ ( bNF_pick_middlep @ A @ B @ C @ P @ Q @ A2 @ C3 ) @ C3 ) ) ) ).

% pick_middlep
thf(fact_191_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X3: A] : ( member @ A @ X3 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_witness
thf(fact_192_UNIV__eq__I,axiom,
    ! [A: $tType,A6: set @ A] :
      ( ! [X3: A] : ( member @ A @ X3 @ A6 )
     => ( ( top_top @ ( set @ A ) )
        = A6 ) ) ).

% UNIV_eq_I
thf(fact_193_nchotomy__relcomppE,axiom,
    ! [C: $tType,B: $tType,A: $tType,D: $tType,F4: B > A,R: C > A > $o,S: A > D > $o,A2: C,C3: D] :
      ( ! [Y: A] :
        ? [X5: B] :
          ( Y
          = ( F4 @ X5 ) )
     => ( ( relcompp @ C @ A @ D @ R @ S @ A2 @ C3 )
       => ~ ! [B4: B] :
              ( ( R @ A2 @ ( F4 @ B4 ) )
             => ~ ( S @ ( F4 @ B4 ) @ C3 ) ) ) ) ).

% nchotomy_relcomppE
thf(fact_194_csquare__def,axiom,
    ! [B: $tType,C: $tType,D: $tType,A: $tType] :
      ( ( bNF_csquare @ A @ B @ C @ D )
      = ( ^ [A7: set @ A,F12: B > C,F23: D > C,P1: A > B,P22: A > D] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A7 )
           => ( ( F12 @ ( P1 @ X4 ) )
              = ( F23 @ ( P22 @ X4 ) ) ) ) ) ) ).

% csquare_def
thf(fact_195_fstOp__in,axiom,
    ! [B: $tType,C: $tType,A: $tType,Ac2: product_prod @ A @ B,P: A > C > $o,Q: C > B > $o] :
      ( ( member @ ( product_prod @ A @ B ) @ Ac2 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ ( relcompp @ A @ C @ B @ P @ Q ) ) ) )
     => ( member @ ( product_prod @ A @ C ) @ ( bNF_fstOp @ A @ C @ B @ P @ Q @ Ac2 ) @ ( collect @ ( product_prod @ A @ C ) @ ( product_case_prod @ A @ C @ $o @ P ) ) ) ) ).

% fstOp_in
thf(fact_196_sndOp__in,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ac2: product_prod @ A @ B,P: A > C > $o,Q: C > B > $o] :
      ( ( member @ ( product_prod @ A @ B ) @ Ac2 @ ( collect @ ( product_prod @ A @ B ) @ ( product_case_prod @ A @ B @ $o @ ( relcompp @ A @ C @ B @ P @ Q ) ) ) )
     => ( member @ ( product_prod @ C @ B ) @ ( bNF_sndOp @ A @ C @ B @ P @ Q @ Ac2 ) @ ( collect @ ( product_prod @ C @ B ) @ ( product_case_prod @ C @ B @ $o @ Q ) ) ) ) ).

% sndOp_in
thf(fact_197_unfold_I1_J,axiom,
    ! [A: $tType,Rt: A > n,Ct: A > ( set @ ( sum_sum @ t @ A ) ),B2: A] :
      ( ( root @ ( unfold @ A @ Rt @ Ct @ B2 ) )
      = ( Rt @ B2 ) ) ).

% unfold(1)
thf(fact_198_surj__def,axiom,
    ! [B: $tType,A: $tType,F4: B > A] :
      ( ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
      = ( ! [Y8: A] :
          ? [X4: B] :
            ( Y8
            = ( F4 @ X4 ) ) ) ) ).

% surj_def
thf(fact_199_surjI,axiom,
    ! [B: $tType,A: $tType,G3: B > A,F4: A > B] :
      ( ! [X3: A] :
          ( ( G3 @ ( F4 @ X3 ) )
          = X3 )
     => ( ( image @ B @ A @ G3 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% surjI
thf(fact_200_top__set__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A @ ( top_top @ ( A > $o ) ) ) ) ).

% top_set_def
thf(fact_201_surjD,axiom,
    ! [A: $tType,B: $tType,F4: B > A,Y3: A] :
      ( ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ? [X3: B] :
          ( Y3
          = ( F4 @ X3 ) ) ) ).

% surjD
thf(fact_202_surjE,axiom,
    ! [A: $tType,B: $tType,F4: B > A,Y3: A] :
      ( ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ~ ! [X3: B] :
            ( Y3
           != ( F4 @ X3 ) ) ) ).

% surjE
thf(fact_203_map__prod__surj,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,F4: A > B,G3: C > D] :
      ( ( ( image @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
        = ( top_top @ ( set @ B ) ) )
     => ( ( ( image @ C @ D @ G3 @ ( top_top @ ( set @ C ) ) )
          = ( top_top @ ( set @ D ) ) )
       => ( ( image @ ( product_prod @ A @ C ) @ ( product_prod @ B @ D ) @ ( product_map_prod @ A @ B @ C @ D @ F4 @ G3 ) @ ( top_top @ ( set @ ( product_prod @ A @ C ) ) ) )
          = ( top_top @ ( set @ ( product_prod @ B @ D ) ) ) ) ) ) ).

% map_prod_surj
thf(fact_204_root__Node,axiom,
    ! [N2: n,As2: set @ ( sum_sum @ t @ dtree )] :
      ( ( root @ ( node @ N2 @ As2 ) )
      = N2 ) ).

% root_Node
thf(fact_205_map__prod__simp,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,F4: C > A,G3: D > B,A2: C,B2: D] :
      ( ( product_map_prod @ C @ A @ D @ B @ F4 @ G3 @ ( product_Pair @ C @ D @ A2 @ B2 ) )
      = ( product_Pair @ A @ B @ ( F4 @ A2 ) @ ( G3 @ B2 ) ) ) ).

% map_prod_simp
thf(fact_206_fst__map__prod,axiom,
    ! [B: $tType,A: $tType,D: $tType,C: $tType,F4: C > A,G3: D > B,X: product_prod @ C @ D] :
      ( ( product_fst @ A @ B @ ( product_map_prod @ C @ A @ D @ B @ F4 @ G3 @ X ) )
      = ( F4 @ ( product_fst @ C @ D @ X ) ) ) ).

% fst_map_prod
thf(fact_207_snd__map__prod,axiom,
    ! [B: $tType,A: $tType,D: $tType,C: $tType,F4: C > B,G3: D > A,X: product_prod @ C @ D] :
      ( ( product_snd @ B @ A @ ( product_map_prod @ C @ B @ D @ A @ F4 @ G3 @ X ) )
      = ( G3 @ ( product_snd @ C @ D @ X ) ) ) ).

% snd_map_prod
thf(fact_208_map__prod__imageI,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,A2: A,B2: B,R2: set @ ( product_prod @ A @ B ),F4: A > C,G3: B > D] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ R2 )
     => ( member @ ( product_prod @ C @ D ) @ ( product_Pair @ C @ D @ ( F4 @ A2 ) @ ( G3 @ B2 ) ) @ ( image @ ( product_prod @ A @ B ) @ ( product_prod @ C @ D ) @ ( product_map_prod @ A @ C @ B @ D @ F4 @ G3 ) @ R2 ) ) ) ).

% map_prod_imageI
thf(fact_209_prod__fun__imageE,axiom,
    ! [B: $tType,A: $tType,D: $tType,C: $tType,C3: product_prod @ A @ B,F4: C > A,G3: D > B,R2: set @ ( product_prod @ C @ D )] :
      ( ( member @ ( product_prod @ A @ B ) @ C3 @ ( image @ ( product_prod @ C @ D ) @ ( product_prod @ A @ B ) @ ( product_map_prod @ C @ A @ D @ B @ F4 @ G3 ) @ R2 ) )
     => ~ ! [X3: C,Y: D] :
            ( ( C3
              = ( product_Pair @ A @ B @ ( F4 @ X3 ) @ ( G3 @ Y ) ) )
           => ~ ( member @ ( product_prod @ C @ D ) @ ( product_Pair @ C @ D @ X3 @ Y ) @ R2 ) ) ) ).

% prod_fun_imageE
thf(fact_210_Node__root__cont,axiom,
    ! [Tr: dtree] :
      ( ( node @ ( root @ Tr ) @ ( cont @ Tr ) )
      = Tr ) ).

% Node_root_cont
thf(fact_211_Powp__mono,axiom,
    ! [A: $tType,A6: A > $o,B6: A > $o] :
      ( ( ord_less_eq @ ( A > $o ) @ A6 @ B6 )
     => ( ord_less_eq @ ( ( set @ A ) > $o ) @ ( powp @ A @ A6 ) @ ( powp @ A @ B6 ) ) ) ).

% Powp_mono
thf(fact_212_dtree__cong,axiom,
    ! [Tr: dtree,Tr3: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr3 ) )
     => ( ( ( cont @ Tr )
          = ( cont @ Tr3 ) )
       => ( Tr = Tr3 ) ) ) ).

% dtree_cong
thf(fact_213_predicate2D__conj,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,Q: A > B > $o,R2: $o,X: A,Y3: B] :
      ( ( ( ord_less_eq @ ( A > B > $o ) @ P @ Q )
        & R2 )
     => ( R2
        & ( ( P @ X @ Y3 )
         => ( Q @ X @ Y3 ) ) ) ) ).

% predicate2D_conj
thf(fact_214_corec_I1_J,axiom,
    ! [A: $tType,Rt: A > n,Ct: A > ( set @ ( sum_sum @ t @ ( sum_sum @ dtree @ A ) ) ),B2: A] :
      ( ( root @ ( corec @ A @ Rt @ Ct @ B2 ) )
      = ( Rt @ B2 ) ) ).

% corec(1)
thf(fact_215_Inl__in__cont__par,axiom,
    ! [T2: t,Tr1: dtree,Tr2: dtree] :
      ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ Tr1 @ Tr2 ) ) ) )
      = ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr1 ) )
        | ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr2 ) ) ) ) ).

% Inl_in_cont_par
thf(fact_216_surj__swap__iff,axiom,
    ! [B: $tType,A: $tType,A2: B,B2: B,F4: B > A] :
      ( ( ( image @ B @ A @ ( swap @ B @ A @ A2 @ B2 @ F4 ) @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
      = ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% surj_swap_iff
thf(fact_217_swap__image__eq,axiom,
    ! [B: $tType,A: $tType,A2: A,A6: set @ A,B2: A,F4: A > B] :
      ( ( member @ A @ A2 @ A6 )
     => ( ( member @ A @ B2 @ A6 )
       => ( ( image @ A @ B @ ( swap @ A @ B @ A2 @ B2 @ F4 ) @ A6 )
          = ( image @ A @ B @ F4 @ A6 ) ) ) ) ).

% swap_image_eq
thf(fact_218_surj__imp__surj__swap,axiom,
    ! [B: $tType,A: $tType,F4: B > A,A2: B,B2: B] :
      ( ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( ( image @ B @ A @ ( swap @ B @ A @ A2 @ B2 @ F4 ) @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) ) ) ).

% surj_imp_surj_swap
thf(fact_219_Sup_OSUP__cong,axiom,
    ! [A: $tType,B: $tType,A6: set @ B,B6: set @ B,C4: B > A,D3: B > A,Sup: ( set @ A ) > A] :
      ( ( A6 = B6 )
     => ( ! [X3: B] :
            ( ( member @ B @ X3 @ B6 )
           => ( ( C4 @ X3 )
              = ( D3 @ X3 ) ) )
       => ( ( Sup @ ( image @ B @ A @ C4 @ A6 ) )
          = ( Sup @ ( image @ B @ A @ D3 @ B6 ) ) ) ) ) ).

% Sup.SUP_cong
thf(fact_220_Inf_OINF__cong,axiom,
    ! [A: $tType,B: $tType,A6: set @ B,B6: set @ B,C4: B > A,D3: B > A,Inf: ( set @ A ) > A] :
      ( ( A6 = B6 )
     => ( ! [X3: B] :
            ( ( member @ B @ X3 @ B6 )
           => ( ( C4 @ X3 )
              = ( D3 @ X3 ) ) )
       => ( ( Inf @ ( image @ B @ A @ C4 @ A6 ) )
          = ( Inf @ ( image @ B @ A @ D3 @ B6 ) ) ) ) ) ).

% Inf.INF_cong
thf(fact_221_surj__Compl__image__subset,axiom,
    ! [A: $tType,B: $tType,F4: B > A,A6: set @ B] :
      ( ( ( image @ B @ A @ F4 @ ( top_top @ ( set @ B ) ) )
        = ( top_top @ ( set @ A ) ) )
     => ( ord_less_eq @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ ( image @ B @ A @ F4 @ A6 ) ) @ ( image @ B @ A @ F4 @ ( uminus_uminus @ ( set @ B ) @ A6 ) ) ) ) ).

% surj_Compl_image_subset
thf(fact_222_in__inv__image,axiom,
    ! [A: $tType,B: $tType,X: A,Y3: A,R: set @ ( product_prod @ B @ B ),F4: A > B] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y3 ) @ ( inv_image @ B @ A @ R @ F4 ) )
      = ( member @ ( product_prod @ B @ B ) @ ( product_Pair @ B @ B @ ( F4 @ X ) @ ( F4 @ Y3 ) ) @ R ) ) ).

% in_inv_image
thf(fact_223_ComplI,axiom,
    ! [A: $tType,C3: A,A6: set @ A] :
      ( ~ ( member @ A @ C3 @ A6 )
     => ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A6 ) ) ) ).

% ComplI
thf(fact_224_Compl__iff,axiom,
    ! [A: $tType,C3: A,A6: set @ A] :
      ( ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A6 ) )
      = ( ~ ( member @ A @ C3 @ A6 ) ) ) ).

% Compl_iff
thf(fact_225_Compl__eq__Compl__iff,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( ( uminus_uminus @ ( set @ A ) @ A6 )
        = ( uminus_uminus @ ( set @ A ) @ B6 ) )
      = ( A6 = B6 ) ) ).

% Compl_eq_Compl_iff
thf(fact_226_Compl__subset__Compl__iff,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A6 ) @ ( uminus_uminus @ ( set @ A ) @ B6 ) )
      = ( ord_less_eq @ ( set @ A ) @ B6 @ A6 ) ) ).

% Compl_subset_Compl_iff
thf(fact_227_Compl__anti__mono,axiom,
    ! [A: $tType,A6: set @ A,B6: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
     => ( ord_less_eq @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ B6 ) @ ( uminus_uminus @ ( set @ A ) @ A6 ) ) ) ).

% Compl_anti_mono
thf(fact_228_ComplD,axiom,
    ! [A: $tType,C3: A,A6: set @ A] :
      ( ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A6 ) )
     => ~ ( member @ A @ C3 @ A6 ) ) ).

% ComplD
thf(fact_229_double__complement,axiom,
    ! [A: $tType,A6: set @ A] :
      ( ( uminus_uminus @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A6 ) )
      = A6 ) ).

% double_complement
thf(fact_230_compl__le__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ X ) @ ( uminus_uminus @ A @ Y3 ) )
          = ( ord_less_eq @ A @ Y3 @ X ) ) ) ).

% compl_le_compl_iff
thf(fact_231_neg__le__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) )
          = ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% neg_le_iff_le
thf(fact_232_compl__mono,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A,Y3: A] :
          ( ( ord_less_eq @ A @ X @ Y3 )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ Y3 ) @ ( uminus_uminus @ A @ X ) ) ) ) ).

% compl_mono
thf(fact_233_compl__le__swap1,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [Y3: A,X: A] :
          ( ( ord_less_eq @ A @ Y3 @ ( uminus_uminus @ A @ X ) )
         => ( ord_less_eq @ A @ X @ ( uminus_uminus @ A @ Y3 ) ) ) ) ).

% compl_le_swap1
thf(fact_234_compl__le__swap2,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [Y3: A,X: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ Y3 ) @ X )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ X ) @ Y3 ) ) ) ).

% compl_le_swap2
thf(fact_235_le__minus__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( uminus_uminus @ A @ B2 ) )
          = ( ord_less_eq @ A @ B2 @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% le_minus_iff
thf(fact_236_minus__le__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ A2 ) @ B2 )
          = ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ A2 ) ) ) ).

% minus_le_iff
thf(fact_237_le__imp__neg__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ ( uminus_uminus @ A @ B2 ) @ ( uminus_uminus @ A @ A2 ) ) ) ) ).

% le_imp_neg_le
thf(fact_238_inj__image__Compl__subset,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
     => ( ord_less_eq @ ( set @ B ) @ ( image @ A @ B @ F4 @ ( uminus_uminus @ ( set @ A ) @ A6 ) ) @ ( uminus_uminus @ ( set @ B ) @ ( image @ A @ B @ F4 @ A6 ) ) ) ) ).

% inj_image_Compl_subset
thf(fact_239_inj__apfst,axiom,
    ! [B: $tType,C: $tType,A: $tType,F4: A > C] :
      ( ( inj_on @ ( product_prod @ A @ B ) @ ( product_prod @ C @ B ) @ ( product_apfst @ A @ C @ B @ F4 ) @ ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) )
      = ( inj_on @ A @ C @ F4 @ ( top_top @ ( set @ A ) ) ) ) ).

% inj_apfst
thf(fact_240_inj__apsnd,axiom,
    ! [A: $tType,C: $tType,B: $tType,F4: B > C] :
      ( ( inj_on @ ( product_prod @ A @ B ) @ ( product_prod @ A @ C ) @ ( product_apsnd @ B @ C @ A @ F4 ) @ ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) )
      = ( inj_on @ B @ C @ F4 @ ( top_top @ ( set @ B ) ) ) ) ).

% inj_apsnd
thf(fact_241_inj__image__subset__iff,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A6: set @ A,B6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
     => ( ( ord_less_eq @ ( set @ B ) @ ( image @ A @ B @ F4 @ A6 ) @ ( image @ A @ B @ F4 @ B6 ) )
        = ( ord_less_eq @ ( set @ A ) @ A6 @ B6 ) ) ) ).

% inj_image_subset_iff
thf(fact_242_inj__image__mem__iff,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A2: A,A6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
     => ( ( member @ B @ ( F4 @ A2 ) @ ( image @ A @ B @ F4 @ A6 ) )
        = ( member @ A @ A2 @ A6 ) ) ) ).

% inj_image_mem_iff
thf(fact_243_inj__image__eq__iff,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A6: set @ A,B6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
     => ( ( ( image @ A @ B @ F4 @ A6 )
          = ( image @ A @ B @ F4 @ B6 ) )
        = ( A6 = B6 ) ) ) ).

% inj_image_eq_iff
thf(fact_244_range__ex1__eq,axiom,
    ! [B: $tType,A: $tType,F4: A > B,B2: B] :
      ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
     => ( ( member @ B @ B2 @ ( image @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) ) )
        = ( ? [X4: A] :
              ( ( B2
                = ( F4 @ X4 ) )
              & ! [Y8: A] :
                  ( ( B2
                    = ( F4 @ Y8 ) )
                 => ( Y8 = X4 ) ) ) ) ) ) ).

% range_ex1_eq
thf(fact_245_inj__swap,axiom,
    ! [B: $tType,A: $tType,A6: set @ ( product_prod @ A @ B )] : ( inj_on @ ( product_prod @ A @ B ) @ ( product_prod @ B @ A ) @ ( product_swap @ A @ B ) @ A6 ) ).

% inj_swap
thf(fact_246_inj__on__image__iff,axiom,
    ! [B: $tType,A: $tType,A6: set @ A,G3: A > B,F4: A > A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A6 )
         => ! [Xa: A] :
              ( ( member @ A @ Xa @ A6 )
             => ( ( ( G3 @ ( F4 @ X3 ) )
                  = ( G3 @ ( F4 @ Xa ) ) )
                = ( ( G3 @ X3 )
                  = ( G3 @ Xa ) ) ) ) )
     => ( ( inj_on @ A @ A @ F4 @ A6 )
       => ( ( inj_on @ A @ B @ G3 @ ( image @ A @ A @ F4 @ A6 ) )
          = ( inj_on @ A @ B @ G3 @ A6 ) ) ) ) ).

% inj_on_image_iff
thf(fact_247_inj__on__subset,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A6: set @ A,B6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ A6 )
     => ( ( ord_less_eq @ ( set @ A ) @ B6 @ A6 )
       => ( inj_on @ A @ B @ F4 @ B6 ) ) ) ).

% inj_on_subset
thf(fact_248_subset__inj__on,axiom,
    ! [B: $tType,A: $tType,F4: A > B,B6: set @ A,A6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ B6 )
     => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
       => ( inj_on @ A @ B @ F4 @ A6 ) ) ) ).

% subset_inj_on
thf(fact_249_inj__on__image__mem__iff__alt,axiom,
    ! [B: $tType,A: $tType,F4: A > B,B6: set @ A,A6: set @ A,A2: A] :
      ( ( inj_on @ A @ B @ F4 @ B6 )
     => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
       => ( ( member @ B @ ( F4 @ A2 ) @ ( image @ A @ B @ F4 @ A6 ) )
         => ( ( member @ A @ A2 @ B6 )
           => ( member @ A @ A2 @ A6 ) ) ) ) ) ).

% inj_on_image_mem_iff_alt
thf(fact_250_inj__on__image__mem__iff,axiom,
    ! [B: $tType,A: $tType,F4: A > B,B6: set @ A,A2: A,A6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ B6 )
     => ( ( member @ A @ A2 @ B6 )
       => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
         => ( ( member @ B @ ( F4 @ A2 ) @ ( image @ A @ B @ F4 @ A6 ) )
            = ( member @ A @ A2 @ A6 ) ) ) ) ) ).

% inj_on_image_mem_iff
thf(fact_251_inj__on__image__eq__iff,axiom,
    ! [B: $tType,A: $tType,F4: A > B,C4: set @ A,A6: set @ A,B6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ C4 )
     => ( ( ord_less_eq @ ( set @ A ) @ A6 @ C4 )
       => ( ( ord_less_eq @ ( set @ A ) @ B6 @ C4 )
         => ( ( ( image @ A @ B @ F4 @ A6 )
              = ( image @ A @ B @ F4 @ B6 ) )
            = ( A6 = B6 ) ) ) ) ) ).

% inj_on_image_eq_iff
thf(fact_252_the__inv__into__into,axiom,
    ! [B: $tType,A: $tType,F4: A > B,A6: set @ A,X: B,B6: set @ A] :
      ( ( inj_on @ A @ B @ F4 @ A6 )
     => ( ( member @ B @ X @ ( image @ A @ B @ F4 @ A6 ) )
       => ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
         => ( member @ A @ ( the_inv_into @ A @ B @ A6 @ F4 @ X ) @ B6 ) ) ) ) ).

% the_inv_into_into
thf(fact_253_wf__map__prod__image,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ A ),F4: A > B] :
      ( ( wf @ A @ R )
     => ( ( inj_on @ A @ B @ F4 @ ( top_top @ ( set @ A ) ) )
       => ( wf @ B @ ( image @ ( product_prod @ A @ A ) @ ( product_prod @ B @ B ) @ ( product_map_prod @ A @ B @ A @ B @ F4 @ F4 ) @ R ) ) ) ) ).

% wf_map_prod_image
thf(fact_254_wf__inv__image,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ B @ B ),F4: A > B] :
      ( ( wf @ B @ R )
     => ( wf @ A @ ( inv_image @ B @ A @ R @ F4 ) ) ) ).

% wf_inv_image
thf(fact_255_wf__lex__prod,axiom,
    ! [A: $tType,B: $tType,Ra: set @ ( product_prod @ A @ A ),Rb: set @ ( product_prod @ B @ B )] :
      ( ( wf @ A @ Ra )
     => ( ( wf @ B @ Rb )
       => ( wf @ ( product_prod @ A @ B ) @ ( lex_prod @ A @ B @ Ra @ Rb ) ) ) ) ).

% wf_lex_prod

%----Type constructors (16)
thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( boolean_algebra @ A9 @ ( type2 @ A9 ) )
     => ( boolean_algebra @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder__top,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( order_top @ A9 @ ( type2 @ A9 ) )
     => ( order_top @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( preorder @ A9 @ ( type2 @ A9 ) )
     => ( preorder @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( order @ A9 @ ( type2 @ A9 ) )
     => ( order @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A8: $tType,A9: $tType] :
      ( ( ord @ A9 @ ( type2 @ A9 ) )
     => ( ord @ ( A8 > A9 ) @ ( type2 @ ( A8 > A9 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_1,axiom,
    ! [A8: $tType] : ( boolean_algebra @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder__top_2,axiom,
    ! [A8: $tType] : ( order_top @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_3,axiom,
    ! [A8: $tType] : ( preorder @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_4,axiom,
    ! [A8: $tType] : ( order @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_5,axiom,
    ! [A8: $tType] : ( ord @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_6,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder__top_7,axiom,
    order_top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_8,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ tr1 @ tr2 ) ) @ tr3 ) )
    = ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ tr1 @ ( parall1899940088le_par @ ( product_Pair @ dtree @ dtree @ tr2 @ tr3 ) ) ) ) ) ).

%------------------------------------------------------------------------------
